import java.io.*;
import java.util.*;
import java.security.*;

public class Person {
	
	/**static variable myId for Persons**/
	private static int myId = 1000;
	private String myName;
	private byte[] myPassword; //MD5 hashed password
	private ArrayList<Account> myAccounts;
	private double myNetWorth;
	private double myPocketMoney;
	
	/** Constructor: creates a new instance of person with their name, password, and pocketMoney. **/
	public Person(String name, String password, double pocketMoney){
		myId = myId++;
		myName = name;
		myPassword = hashPassword(password);
		myPocketMoney = pocketMoney;
		myNetWorth = pocketMoney;
		myAccounts = new ArrayList<Account>();
	}

	
	/** Modifier: Sets the pocket money of the person to value **/
	public void setPocketMoney(double value){
		myPocketMoney = value;
	}
	
	/**Accessor: returns the value of pocket money. **/
	public double getPocketMoney(){
		return myPocketMoney;
	}
	
	/**Calculates the net worth of the person by summing his assets in his accounts and adding that to his pocket money**/
	public double getNetWorth(){
		myNetWorth = myPocketMoney;
		
		for(int i = 0; i < myAccounts.size(); i++){
			myNetWorth += myAccounts.get(i).getBalance();
		}
		
		return myNetWorth;
	}
	
	/**Accessor: returns the ID of the person **/
	public int getId(){
		return myId;
	}
	/**Accessor: returns the name of the person **/
	public String getName(){
		return myName;
	}
	
	/**Accessor: Returns the arraylist containing the accounts the person has **/
	public ArrayList<Account> getAccounts(){
		return myAccounts;
	}
	
	/** Returns a boolean that verifies that the person's password, so that they can modify their accounts etc. *
	 * @throws IOException */
	public boolean requestPassword() throws IOException {
		for (int x = 0; x < 3; ++x) {
			System.out.print("Please enter " + this.getName() +"'s password: ");
			InputStreamReader isr = new InputStreamReader(System.in);
			BufferedReader comingIn = new BufferedReader(isr);
			String response = comingIn.readLine();

			if(Arrays.equals(hashPassword(response), myPassword)){
				return true;
			}
			else{
				System.out.println("Incorrect password.");
			}
		}
		System.out.println("3 incorrect passwords. Blocking access.");
		return false;
	}
	
	/** = an MD5 hash of the given string **/
	public static byte[] hashPassword(String p) {
		try {
			MessageDigest d = MessageDigest.getInstance("MD5");
			d.update(p.getBytes());
			return d.digest();
		}
		catch (NoSuchAlgorithmException e) {}
		return null;		
	}
	
	/** Closes an account by removing from the arraylist of accounts for the person and the bank *
	 * @throws IOException */
	public void closeAccount(Account acc) throws IOException{
		Bank b = (Bank) acc.getLocation();
		if (b.closeAccount(acc)) { 
			Transfer.transfer(acc, this);
			myAccounts.remove(acc);
		}
	}
	
	/**Opens an account by adding it to the bank accounts, and personal accounts *
	 * @throws IOException */
	public Account openAccount(Bank b, int type, double startBal) throws IOException{  //type of account is either 0 (checking) or 1 (savings)
		Account acc = b.createAccount(type, this, startBal);
		if (acc != null) {
			myAccounts.add(acc);
			return acc;
		}
		return null;
	}
	
	/**Opens an account by adding it to the credit card co accounts, and personal accounts *
	 * @throws IOException */
	public Account openCreditCard(CreditCardCompany c) throws IOException{  //type of account is either 0 (checking) or 1 (savings)
		Account acc = c.applyForCard(this);
		if (acc != null) {
			myAccounts.add(acc);
			return acc;
		}
		return null;
	}
	
	/** Closes an account by removing from the arraylist of accounts for the person and the bank *
	 * @throws IOException */
	public void cancelCreditCard(CreditCardAccount acc) throws IOException{
		CreditCardCompany b = (CreditCardCompany) acc.getLocation();
		if (b.cancelCard(acc)) { 
			Transfer.transfer(acc, this);
			myAccounts.remove(acc);
		}
	}
	
	/**Overridden method to compare 2 people **/
	public boolean equals(Person a){
		if(a.getId() == myId){return true;} else{return false;}
	}
	
	/** String representation of this Person **/
	public String toString() {
		return "Person " + getName() + " has $" + getPocketMoney() + " in cash and a total net worth of $" + getNetWorth() + " including what's in " + getAccounts().size() + " accounts.";
	}

}
